<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByProduct
{

    /**
     * @var string $productIdentifier
     */
    protected $productIdentifier = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param string $productIdentifier
     * @param ProductIdentifierType $productIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($productIdentifier = null, $productIdentifierType = null, \DateTime $modifiedSinceDate = null, $nonZeroOnly = null)
    {
      $this->productIdentifier = $productIdentifier;
      $this->productIdentifierType = $productIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate ? $modifiedSinceDate->format(\DateTime::ATOM) : null;
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->productIdentifier;
    }

    /**
     * @param string $productIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByProduct
     */
    public function setProductIdentifier($productIdentifier)
    {
      $this->productIdentifier = $productIdentifier;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByProduct
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentStockPositionByProduct
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentStockPositionByProduct
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
