<?php

namespace Eurostop\Stocks;

class ConfirmTransfers
{

    /**
     * @var ArrayOfstring $transferIdentifiers
     */
    protected $transferIdentifiers = null;

    /**
     * @var TransferIdentifierType $transferIdentifierType
     */
    protected $transferIdentifierType = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfstring $transferIdentifiers
     * @param TransferIdentifierType $transferIdentifierType
     * @param string $submissionReference
     */
    public function __construct($transferIdentifiers = null, $transferIdentifierType = null, $submissionReference = null)
    {
      $this->transferIdentifiers = $transferIdentifiers;
      $this->transferIdentifierType = $transferIdentifierType;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfstring
     */
    public function getTransferIdentifiers()
    {
      return $this->transferIdentifiers;
    }

    /**
     * @param ArrayOfstring $transferIdentifiers
     * @return \Eurostop\Stocks\ConfirmTransfers
     */
    public function setTransferIdentifiers($transferIdentifiers)
    {
      $this->transferIdentifiers = $transferIdentifiers;
      return $this;
    }

    /**
     * @return TransferIdentifierType
     */
    public function getTransferIdentifierType()
    {
      return $this->transferIdentifierType;
    }

    /**
     * @param TransferIdentifierType $transferIdentifierType
     * @return \Eurostop\Stocks\ConfirmTransfers
     */
    public function setTransferIdentifierType($transferIdentifierType)
    {
      $this->transferIdentifierType = $transferIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\ConfirmTransfers
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
