<?php

namespace Eurostop\Status;

class ArrayOfDataProcessingStatus implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var DataProcessingStatus[] $DataProcessingStatus
     */
    protected $DataProcessingStatus = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return DataProcessingStatus[]
     */
    public function getDataProcessingStatus()
    {
      return $this->DataProcessingStatus;
    }

    /**
     * @param DataProcessingStatus[] $DataProcessingStatus
     * @return \Eurostop\Status\ArrayOfDataProcessingStatus
     */
    public function setDataProcessingStatus(array $DataProcessingStatus = null)
    {
      $this->DataProcessingStatus = $DataProcessingStatus;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->DataProcessingStatus[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return DataProcessingStatus
     */
    public function offsetGet($offset)
    {
      return $this->DataProcessingStatus[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param DataProcessingStatus $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->DataProcessingStatus[] = $value;
      } else {
        $this->DataProcessingStatus[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->DataProcessingStatus[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return DataProcessingStatus Return the current element
     */
    public function current()
    {
      return current($this->DataProcessingStatus);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->DataProcessingStatus);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->DataProcessingStatus);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->DataProcessingStatus);
    }

    /**
     * Countable implementation
     *
     * @return DataProcessingStatus Return count of elements
     */
    public function count()
    {
      return count($this->DataProcessingStatus);
    }

}
