<?php

namespace Eurostop\Security;

class SecurityWebServiceInterfacePluginCustom extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'DateTimeOffset' => 'Eurostop\\Security\\DateTimeOffsetCustom',
      'AuthenticationResult' => 'Eurostop\\Security\\AuthenticationResultCustom',
      'Login' => 'Eurostop\\Security\\LoginCustom',
      'LoginResponse' => 'Eurostop\\Security\\LoginResponseCustom',
      'RenewAuthToken' => 'Eurostop\\Security\\RenewAuthTokenCustom',
      'RenewAuthTokenResponse' => 'Eurostop\\Security\\RenewAuthTokenResponseCustom',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://retailtest.trotters.co.uk:6500/e-interface/security?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param LoginCustom $parameters
     * @return LoginResponse
     */
    public function Login($parameters)
    {
      return $this->__soapCall('Login', array($parameters));
    }

    /**
     * @param RenewAuthTokenCustom $parameters
     * @return RenewAuthTokenResponse
     */
    public function RenewAuthToken($parameters)
    {
      return $this->__soapCall('RenewAuthToken', array($parameters));
    }

}
