<?php

namespace Eurostop\Security;

class SecurityWebServiceInterfacePlugin extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'DateTimeOffset' => 'Eurostop\\Security\\DateTimeOffset',
      'AuthenticationResult' => 'Eurostop\\Security\\AuthenticationResult',
      'Login' => 'Eurostop\\Security\\Login',
      'LoginResponse' => 'Eurostop\\Security\\LoginResponse',
      'RenewAuthToken' => 'Eurostop\\Security\\RenewAuthToken',
      'RenewAuthTokenResponse' => 'Eurostop\\Security\\RenewAuthTokenResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://retailtest.trotters.co.uk:6500/e-interface/security?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param Login $parameters
     * @return LoginResponse
     */
    public function Login(Login $parameters)
    {
      return $this->__soapCall('Login', array($parameters));
    }

    /**
     * @param RenewAuthToken $parameters
     * @return RenewAuthTokenResponse
     */
    public function RenewAuthToken(RenewAuthToken $parameters)
    {
      return $this->__soapCall('RenewAuthToken', array($parameters));
    }

}
