<?php

namespace Eurostop\Sales;

class GetReceiptsByBranchTransactionDate
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $fromDate
     */
    protected $fromDate = null;

    /**
     * @var \DateTime $toDate
     */
    protected $toDate = null;

    /**
     * @var int $maxReceipts
     */
    protected $maxReceipts = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $fromDate
     * @param \DateTime $toDate
     * @param int $maxReceipts
     */
    public function __construct($branchIdentifier = null, $branchIdentifierType = null, \DateTime $fromDate = null, \DateTime $toDate = null, $maxReceipts = null)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->fromDate = $fromDate ? $fromDate->format(\DateTime::ATOM) : null;
      $this->toDate = $toDate ? $toDate->format(\DateTime::ATOM) : null;
      $this->maxReceipts = $maxReceipts;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Sales\GetReceiptsByBranchTransactionDate
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Sales\GetReceiptsByBranchTransactionDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getFromDate()
    {
      if ($this->fromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->fromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $fromDate
     * @return \Eurostop\Sales\GetReceiptsByBranchTransactionDate
     */
    public function setFromDate(\DateTime $fromDate)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getToDate()
    {
      if ($this->toDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->toDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $toDate
     * @return \Eurostop\Sales\GetReceiptsByBranchTransactionDate
     */
    public function setToDate(\DateTime $toDate)
    {
      $this->toDate = $toDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxReceipts()
    {
      return $this->maxReceipts;
    }

    /**
     * @param int $maxReceipts
     * @return \Eurostop\Sales\GetReceiptsByBranchTransactionDate
     */
    public function setMaxReceipts($maxReceipts)
    {
      $this->maxReceipts = $maxReceipts;
      return $this;
    }

}
