<?php

namespace Eurostop\Sales;

class GetReceiptByReceiptIdentifier
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var int $tillNumber
     */
    protected $tillNumber = null;

    /**
     * @var string $receiptIdentifier
     */
    protected $receiptIdentifier = null;

    /**
     * @var ReceiptIdentifierType $receiptIdentifierType
     */
    protected $receiptIdentifierType = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param int $tillNumber
     * @param string $receiptIdentifier
     * @param ReceiptIdentifierType $receiptIdentifierType
     */
    public function __construct($branchIdentifier = null, $branchIdentifierType = null, $tillNumber = null, $receiptIdentifier = null, $receiptIdentifierType = null)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->tillNumber = $tillNumber;
      $this->receiptIdentifier = $receiptIdentifier;
      $this->receiptIdentifierType = $receiptIdentifierType;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Sales\GetReceiptByReceiptIdentifier
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Sales\GetReceiptByReceiptIdentifier
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->tillNumber;
    }

    /**
     * @param int $tillNumber
     * @return \Eurostop\Sales\GetReceiptByReceiptIdentifier
     */
    public function setTillNumber($tillNumber)
    {
      $this->tillNumber = $tillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceiptIdentifier()
    {
      return $this->receiptIdentifier;
    }

    /**
     * @param string $receiptIdentifier
     * @return \Eurostop\Sales\GetReceiptByReceiptIdentifier
     */
    public function setReceiptIdentifier($receiptIdentifier)
    {
      $this->receiptIdentifier = $receiptIdentifier;
      return $this;
    }

    /**
     * @return ReceiptIdentifierType
     */
    public function getReceiptIdentifierType()
    {
      return $this->receiptIdentifierType;
    }

    /**
     * @param ReceiptIdentifierType $receiptIdentifierType
     * @return \Eurostop\Sales\GetReceiptByReceiptIdentifier
     */
    public function setReceiptIdentifierType($receiptIdentifierType)
    {
      $this->receiptIdentifierType = $receiptIdentifierType;
      return $this;
    }

}
