<?php

namespace Eurostop\Products;

class SubmittedSku extends SubmittedDataItemOfSubmittedSkuDtoVNxenGD6
{

    /**
     * @var AvailabilityType $Availability
     */
    protected $Availability = null;

    /**
     * @var string $ColourIdentifier
     */
    protected $ColourIdentifier = null;

    /**
     * @var ColourIdentifierType $ColourIdentifierType
     */
    protected $ColourIdentifierType = null;

    /**
     * @var float $CurrentCostPrice
     */
    protected $CurrentCostPrice = null;

    /**
     * @var float $CurrentRecommendedPrice
     */
    protected $CurrentRecommendedPrice = null;

    /**
     * @var float $CurrentSellingPrice
     */
    protected $CurrentSellingPrice = null;

    /**
     * @var string $EanCode
     */
    protected $EanCode = null;

    /**
     * @var string $ExistCode
     */
    protected $ExistCode = null;

    /**
     * @var float $FranchiseSellingPrice
     */
    protected $FranchiseSellingPrice = null;

    /**
     * @var LifecycleStatusType $LifecycleStatus
     */
    protected $LifecycleStatus = null;

    /**
     * @var float $OriginalRecommendedPrice
     */
    protected $OriginalRecommendedPrice = null;

    /**
     * @var float $OriginalSellingPrice
     */
    protected $OriginalSellingPrice = null;

    /**
     * @var string $PosCode
     */
    protected $PosCode = null;

    /**
     * @var int $SizeGroupSizeOrder
     */
    protected $SizeGroupSizeOrder = null;

    /**
     * @var string $SizeIdentifier
     */
    protected $SizeIdentifier = null;

    /**
     * @var SizeIdentifierType $SizeIdentifierType
     */
    protected $SizeIdentifierType = null;

    /**
     * @var ArrayOfSubmittedSkuAnalysisValue $SkuAnalysisValues
     */
    protected $SkuAnalysisValues = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @var string $VatRateIdentifier
     */
    protected $VatRateIdentifier = null;

    /**
     * @var VatRateIdentifierType $VatRateIdentifierType
     */
    protected $VatRateIdentifierType = null;

    /**
     * @var float $WholeSaleSellingPrice
     */
    protected $WholeSaleSellingPrice = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return AvailabilityType
     */
    public function getAvailability()
    {
      return $this->Availability;
    }

    /**
     * @param AvailabilityType $Availability
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setAvailability($Availability)
    {
      $this->Availability = $Availability;
      return $this;
    }

    /**
     * @return string
     */
    public function getColourIdentifier()
    {
      return $this->ColourIdentifier;
    }

    /**
     * @param string $ColourIdentifier
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setColourIdentifier($ColourIdentifier)
    {
      $this->ColourIdentifier = $ColourIdentifier;
      return $this;
    }

    /**
     * @return ColourIdentifierType
     */
    public function getColourIdentifierType()
    {
      return $this->ColourIdentifierType;
    }

    /**
     * @param ColourIdentifierType $ColourIdentifierType
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setColourIdentifierType($ColourIdentifierType)
    {
      $this->ColourIdentifierType = $ColourIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentCostPrice()
    {
      return $this->CurrentCostPrice;
    }

    /**
     * @param float $CurrentCostPrice
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setCurrentCostPrice($CurrentCostPrice)
    {
      $this->CurrentCostPrice = $CurrentCostPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentRecommendedPrice()
    {
      return $this->CurrentRecommendedPrice;
    }

    /**
     * @param float $CurrentRecommendedPrice
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setCurrentRecommendedPrice($CurrentRecommendedPrice)
    {
      $this->CurrentRecommendedPrice = $CurrentRecommendedPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentSellingPrice()
    {
      return $this->CurrentSellingPrice;
    }

    /**
     * @param float $CurrentSellingPrice
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setCurrentSellingPrice($CurrentSellingPrice)
    {
      $this->CurrentSellingPrice = $CurrentSellingPrice;
      return $this;
    }

    /**
     * @return string
     */
    public function getEanCode()
    {
      return $this->EanCode;
    }

    /**
     * @param string $EanCode
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setEanCode($EanCode)
    {
      $this->EanCode = $EanCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getExistCode()
    {
      return $this->ExistCode;
    }

    /**
     * @param string $ExistCode
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setExistCode($ExistCode)
    {
      $this->ExistCode = $ExistCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getFranchiseSellingPrice()
    {
      return $this->FranchiseSellingPrice;
    }

    /**
     * @param float $FranchiseSellingPrice
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setFranchiseSellingPrice($FranchiseSellingPrice)
    {
      $this->FranchiseSellingPrice = $FranchiseSellingPrice;
      return $this;
    }

    /**
     * @return LifecycleStatusType
     */
    public function getLifecycleStatus()
    {
      return $this->LifecycleStatus;
    }

    /**
     * @param LifecycleStatusType $LifecycleStatus
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setLifecycleStatus($LifecycleStatus)
    {
      $this->LifecycleStatus = $LifecycleStatus;
      return $this;
    }

    /**
     * @return float
     */
    public function getOriginalRecommendedPrice()
    {
      return $this->OriginalRecommendedPrice;
    }

    /**
     * @param float $OriginalRecommendedPrice
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setOriginalRecommendedPrice($OriginalRecommendedPrice)
    {
      $this->OriginalRecommendedPrice = $OriginalRecommendedPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getOriginalSellingPrice()
    {
      return $this->OriginalSellingPrice;
    }

    /**
     * @param float $OriginalSellingPrice
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setOriginalSellingPrice($OriginalSellingPrice)
    {
      $this->OriginalSellingPrice = $OriginalSellingPrice;
      return $this;
    }

    /**
     * @return string
     */
    public function getPosCode()
    {
      return $this->PosCode;
    }

    /**
     * @param string $PosCode
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setPosCode($PosCode)
    {
      $this->PosCode = $PosCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getSizeGroupSizeOrder()
    {
      return $this->SizeGroupSizeOrder;
    }

    /**
     * @param int $SizeGroupSizeOrder
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setSizeGroupSizeOrder($SizeGroupSizeOrder)
    {
      $this->SizeGroupSizeOrder = $SizeGroupSizeOrder;
      return $this;
    }

    /**
     * @return string
     */
    public function getSizeIdentifier()
    {
      return $this->SizeIdentifier;
    }

    /**
     * @param string $SizeIdentifier
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setSizeIdentifier($SizeIdentifier)
    {
      $this->SizeIdentifier = $SizeIdentifier;
      return $this;
    }

    /**
     * @return SizeIdentifierType
     */
    public function getSizeIdentifierType()
    {
      return $this->SizeIdentifierType;
    }

    /**
     * @param SizeIdentifierType $SizeIdentifierType
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setSizeIdentifierType($SizeIdentifierType)
    {
      $this->SizeIdentifierType = $SizeIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedSkuAnalysisValue
     */
    public function getSkuAnalysisValues()
    {
      return $this->SkuAnalysisValues;
    }

    /**
     * @param ArrayOfSubmittedSkuAnalysisValue $SkuAnalysisValues
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setSkuAnalysisValues($SkuAnalysisValues)
    {
      $this->SkuAnalysisValues = $SkuAnalysisValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getVatRateIdentifier()
    {
      return $this->VatRateIdentifier;
    }

    /**
     * @param string $VatRateIdentifier
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setVatRateIdentifier($VatRateIdentifier)
    {
      $this->VatRateIdentifier = $VatRateIdentifier;
      return $this;
    }

    /**
     * @return VatRateIdentifierType
     */
    public function getVatRateIdentifierType()
    {
      return $this->VatRateIdentifierType;
    }

    /**
     * @param VatRateIdentifierType $VatRateIdentifierType
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setVatRateIdentifierType($VatRateIdentifierType)
    {
      $this->VatRateIdentifierType = $VatRateIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getWholeSaleSellingPrice()
    {
      return $this->WholeSaleSellingPrice;
    }

    /**
     * @param float $WholeSaleSellingPrice
     * @return \Eurostop\Products\SubmittedSku
     */
    public function setWholeSaleSellingPrice($WholeSaleSellingPrice)
    {
      $this->WholeSaleSellingPrice = $WholeSaleSellingPrice;
      return $this;
    }

}
