<?php

namespace Eurostop\Products;

class SubmitSizeGroup
{

    /**
     * @var SubmittedSizeGroup $sizeGroup
     */
    protected $sizeGroup = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedSizeGroup $sizeGroup
     * @param string $submissionReference
     */
    public function __construct($sizeGroup = null, $submissionReference = null)
    {
      $this->sizeGroup = $sizeGroup;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedSizeGroup
     */
    public function getSizeGroup()
    {
      return $this->sizeGroup;
    }

    /**
     * @param SubmittedSizeGroup $sizeGroup
     * @return \Eurostop\Products\SubmitSizeGroup
     */
    public function setSizeGroup($sizeGroup)
    {
      $this->sizeGroup = $sizeGroup;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSizeGroup
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
