<?php

namespace Eurostop\Products;

class SubmitProductSkus
{

    /**
     * @var ArrayOfSubmittedProductSku $productSkus
     */
    protected $productSkus = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedProductSku $productSkus
     * @param string $submissionReference
     */
    public function __construct($productSkus = null, $submissionReference = null)
    {
      $this->productSkus = $productSkus;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedProductSku
     */
    public function getProductSkus()
    {
      return $this->productSkus;
    }

    /**
     * @param ArrayOfSubmittedProductSku $productSkus
     * @return \Eurostop\Products\SubmitProductSkus
     */
    public function setProductSkus($productSkus)
    {
      $this->productSkus = $productSkus;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitProductSkus
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
