<?php

namespace Eurostop\Products;

class SubmitColour
{

    /**
     * @var SubmittedColour $colour
     */
    protected $colour = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedColour $colour
     * @param string $submissionReference
     */
    public function __construct($colour = null, $submissionReference = null)
    {
      $this->colour = $colour;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedColour
     */
    public function getColour()
    {
      return $this->colour;
    }

    /**
     * @param SubmittedColour $colour
     * @return \Eurostop\Products\SubmitColour
     */
    public function setColour($colour)
    {
      $this->colour = $colour;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitColour
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
