<?php

namespace Eurostop\Products;

class SkuPrice extends RetrievedDataItemOfSkuPriceDtoVNxenGD6
{

    /**
     * @var string $CountryIdentifier
     */
    protected $CountryIdentifier = null;

    /**
     * @var string $CurrencyIdentifier
     */
    protected $CurrencyIdentifier = null;

    /**
     * @var float $CurrentRecommendedPrice
     */
    protected $CurrentRecommendedPrice = null;

    /**
     * @var float $CurrentSellingPrice
     */
    protected $CurrentSellingPrice = null;

    /**
     * @var \DateTime $LastUpdatedDate
     */
    protected $LastUpdatedDate = null;

    /**
     * @var float $OriginalRecommendedPrice
     */
    protected $OriginalRecommendedPrice = null;

    /**
     * @var float $OriginalSellingPrice
     */
    protected $OriginalSellingPrice = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->CountryIdentifier;
    }

    /**
     * @param string $CountryIdentifier
     * @return \Eurostop\Products\SkuPrice
     */
    public function setCountryIdentifier($CountryIdentifier)
    {
      $this->CountryIdentifier = $CountryIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrencyIdentifier()
    {
      return $this->CurrencyIdentifier;
    }

    /**
     * @param string $CurrencyIdentifier
     * @return \Eurostop\Products\SkuPrice
     */
    public function setCurrencyIdentifier($CurrencyIdentifier)
    {
      $this->CurrencyIdentifier = $CurrencyIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentRecommendedPrice()
    {
      return $this->CurrentRecommendedPrice;
    }

    /**
     * @param float $CurrentRecommendedPrice
     * @return \Eurostop\Products\SkuPrice
     */
    public function setCurrentRecommendedPrice($CurrentRecommendedPrice)
    {
      $this->CurrentRecommendedPrice = $CurrentRecommendedPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentSellingPrice()
    {
      return $this->CurrentSellingPrice;
    }

    /**
     * @param float $CurrentSellingPrice
     * @return \Eurostop\Products\SkuPrice
     */
    public function setCurrentSellingPrice($CurrentSellingPrice)
    {
      $this->CurrentSellingPrice = $CurrentSellingPrice;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdatedDate()
    {
      if ($this->LastUpdatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdatedDate
     * @return \Eurostop\Products\SkuPrice
     */
    public function setLastUpdatedDate(\DateTime $LastUpdatedDate = null)
    {
      if ($LastUpdatedDate == null) {
       $this->LastUpdatedDate = null;
      } else {
        $this->LastUpdatedDate = $LastUpdatedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getOriginalRecommendedPrice()
    {
      return $this->OriginalRecommendedPrice;
    }

    /**
     * @param float $OriginalRecommendedPrice
     * @return \Eurostop\Products\SkuPrice
     */
    public function setOriginalRecommendedPrice($OriginalRecommendedPrice)
    {
      $this->OriginalRecommendedPrice = $OriginalRecommendedPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getOriginalSellingPrice()
    {
      return $this->OriginalSellingPrice;
    }

    /**
     * @param float $OriginalSellingPrice
     * @return \Eurostop\Products\SkuPrice
     */
    public function setOriginalSellingPrice($OriginalSellingPrice)
    {
      $this->OriginalSellingPrice = $OriginalSellingPrice;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Products\SkuPrice
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

}
