<?php

namespace Eurostop\Products;

class GetSkuPricesByCountryAndSkuList
{

    /**
     * @var string $countryIdentifier
     */
    protected $countryIdentifier = null;

    /**
     * @var CountryIdentifierType $countryIdentifierType
     */
    protected $countryIdentifierType = null;

    /**
     * @var ArrayOfstring $skuIdentifiers
     */
    protected $skuIdentifiers = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @param string $countryIdentifier
     * @param CountryIdentifierType $countryIdentifierType
     * @param ArrayOfstring $skuIdentifiers
     * @param SkuIdentifierType $skuIdentifierType
     * @param \DateTime $modifiedSinceDate
     */
    public function __construct($countryIdentifier = null, $countryIdentifierType = null, $skuIdentifiers = null, $skuIdentifierType = null, \DateTime $modifiedSinceDate = null)
    {
      $this->countryIdentifier = $countryIdentifier;
      $this->countryIdentifierType = $countryIdentifierType;
      $this->skuIdentifiers = $skuIdentifiers;
      $this->skuIdentifierType = $skuIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate ? $modifiedSinceDate->format(\DateTime::ATOM) : null;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->countryIdentifier;
    }

    /**
     * @param string $countryIdentifier
     * @return \Eurostop\Products\GetSkuPricesByCountryAndSkuList
     */
    public function setCountryIdentifier($countryIdentifier)
    {
      $this->countryIdentifier = $countryIdentifier;
      return $this;
    }

    /**
     * @return CountryIdentifierType
     */
    public function getCountryIdentifierType()
    {
      return $this->countryIdentifierType;
    }

    /**
     * @param CountryIdentifierType $countryIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountryAndSkuList
     */
    public function setCountryIdentifierType($countryIdentifierType)
    {
      $this->countryIdentifierType = $countryIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSkuIdentifiers()
    {
      return $this->skuIdentifiers;
    }

    /**
     * @param ArrayOfstring $skuIdentifiers
     * @return \Eurostop\Products\GetSkuPricesByCountryAndSkuList
     */
    public function setSkuIdentifiers($skuIdentifiers)
    {
      $this->skuIdentifiers = $skuIdentifiers;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountryAndSkuList
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetSkuPricesByCountryAndSkuList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

}
