<?php

namespace Eurostop\Products;

class GetSkuPricesByCountryAndProductList
{

    /**
     * @var string $countryIdentifier
     */
    protected $countryIdentifier = null;

    /**
     * @var CountryIdentifierType $countryIdentifierType
     */
    protected $countryIdentifierType = null;

    /**
     * @var ArrayOfstring $productIdentifiers
     */
    protected $productIdentifiers = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @param string $countryIdentifier
     * @param CountryIdentifierType $countryIdentifierType
     * @param ArrayOfstring $productIdentifiers
     * @param ProductIdentifierType $productIdentifierType
     * @param \DateTime $modifiedSinceDate
     */
    public function __construct($countryIdentifier = null, $countryIdentifierType = null, $productIdentifiers = null, $productIdentifierType = null, \DateTime $modifiedSinceDate = null)
    {
      $this->countryIdentifier = $countryIdentifier;
      $this->countryIdentifierType = $countryIdentifierType;
      $this->productIdentifiers = $productIdentifiers;
      $this->productIdentifierType = $productIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate ? $modifiedSinceDate->format(\DateTime::ATOM) : null;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->countryIdentifier;
    }

    /**
     * @param string $countryIdentifier
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductList
     */
    public function setCountryIdentifier($countryIdentifier)
    {
      $this->countryIdentifier = $countryIdentifier;
      return $this;
    }

    /**
     * @return CountryIdentifierType
     */
    public function getCountryIdentifierType()
    {
      return $this->countryIdentifierType;
    }

    /**
     * @param CountryIdentifierType $countryIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductList
     */
    public function setCountryIdentifierType($countryIdentifierType)
    {
      $this->countryIdentifierType = $countryIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getProductIdentifiers()
    {
      return $this->productIdentifiers;
    }

    /**
     * @param ArrayOfstring $productIdentifiers
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductList
     */
    public function setProductIdentifiers($productIdentifiers)
    {
      $this->productIdentifiers = $productIdentifiers;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductList
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

}
