<?php

namespace Eurostop\Products;

class GetProductsByExtendedAttributeValue
{

    /**
     * @var string $extendedAttributeTypeIdentifier
     */
    protected $extendedAttributeTypeIdentifier = null;

    /**
     * @var string $extendedAttributeValue
     */
    protected $extendedAttributeValue = null;

    /**
     * @var ExtendedAttributeTypeIdentifierType $extendedAttributeTypeIdentifierType
     */
    protected $extendedAttributeTypeIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $returnAnalysisValues
     */
    protected $returnAnalysisValues = null;

    /**
     * @var boolean $returnExtendedAttributeValues
     */
    protected $returnExtendedAttributeValues = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $extendedAttributeTypeIdentifier
     * @param string $extendedAttributeValue
     * @param ExtendedAttributeTypeIdentifierType $extendedAttributeTypeIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $returnAnalysisValues
     * @param boolean $returnExtendedAttributeValues
     * @param string $cultureCode
     */
    public function __construct($extendedAttributeTypeIdentifier = null, $extendedAttributeValue = null, $extendedAttributeTypeIdentifierType = null, \DateTime $modifiedSinceDate = null, $returnAnalysisValues = null, $returnExtendedAttributeValues = null, $cultureCode = null)
    {
      $this->extendedAttributeTypeIdentifier = $extendedAttributeTypeIdentifier;
      $this->extendedAttributeValue = $extendedAttributeValue;
      $this->extendedAttributeTypeIdentifierType = $extendedAttributeTypeIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate ? $modifiedSinceDate->format(\DateTime::ATOM) : null;
      $this->returnAnalysisValues = $returnAnalysisValues;
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getExtendedAttributeTypeIdentifier()
    {
      return $this->extendedAttributeTypeIdentifier;
    }

    /**
     * @param string $extendedAttributeTypeIdentifier
     * @return \Eurostop\Products\GetProductsByExtendedAttributeValue
     */
    public function setExtendedAttributeTypeIdentifier($extendedAttributeTypeIdentifier)
    {
      $this->extendedAttributeTypeIdentifier = $extendedAttributeTypeIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getExtendedAttributeValue()
    {
      return $this->extendedAttributeValue;
    }

    /**
     * @param string $extendedAttributeValue
     * @return \Eurostop\Products\GetProductsByExtendedAttributeValue
     */
    public function setExtendedAttributeValue($extendedAttributeValue)
    {
      $this->extendedAttributeValue = $extendedAttributeValue;
      return $this;
    }

    /**
     * @return ExtendedAttributeTypeIdentifierType
     */
    public function getExtendedAttributeTypeIdentifierType()
    {
      return $this->extendedAttributeTypeIdentifierType;
    }

    /**
     * @param ExtendedAttributeTypeIdentifierType $extendedAttributeTypeIdentifierType
     * @return \Eurostop\Products\GetProductsByExtendedAttributeValue
     */
    public function setExtendedAttributeTypeIdentifierType($extendedAttributeTypeIdentifierType)
    {
      $this->extendedAttributeTypeIdentifierType = $extendedAttributeTypeIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetProductsByExtendedAttributeValue
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnAnalysisValues()
    {
      return $this->returnAnalysisValues;
    }

    /**
     * @param boolean $returnAnalysisValues
     * @return \Eurostop\Products\GetProductsByExtendedAttributeValue
     */
    public function setReturnAnalysisValues($returnAnalysisValues)
    {
      $this->returnAnalysisValues = $returnAnalysisValues;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnExtendedAttributeValues()
    {
      return $this->returnExtendedAttributeValues;
    }

    /**
     * @param boolean $returnExtendedAttributeValues
     * @return \Eurostop\Products\GetProductsByExtendedAttributeValue
     */
    public function setReturnExtendedAttributeValues($returnExtendedAttributeValues)
    {
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetProductsByExtendedAttributeValue
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
