<?php

namespace Eurostop\Products;

class ArrayOfSubmittedProduct implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedProduct[] $SubmittedProduct
     */
    protected $SubmittedProduct = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedProduct[]
     */
    public function getSubmittedProduct()
    {
      return $this->SubmittedProduct;
    }

    /**
     * @param SubmittedProduct[] $SubmittedProduct
     * @return \Eurostop\Products\ArrayOfSubmittedProduct
     */
    public function setSubmittedProduct(array $SubmittedProduct = null)
    {
      $this->SubmittedProduct = $SubmittedProduct;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedProduct[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedProduct
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedProduct[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedProduct $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedProduct[] = $value;
      } else {
        $this->SubmittedProduct[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedProduct[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedProduct Return the current element
     */
    public function current()
    {
      return current($this->SubmittedProduct);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedProduct);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedProduct);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedProduct);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedProduct Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedProduct);
    }

}
