<?php

namespace Eurostop\Organisation;

class SubmitCurrencyConversionRate
{

    /**
     * @var SubmittedCurrencyConversion $currencyConversion
     */
    protected $currencyConversion = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedCurrencyConversion $currencyConversion
     * @param string $submissionReference
     */
    public function __construct($currencyConversion = null, $submissionReference = null)
    {
      $this->currencyConversion = $currencyConversion;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedCurrencyConversion
     */
    public function getCurrencyConversion()
    {
      return $this->currencyConversion;
    }

    /**
     * @param SubmittedCurrencyConversion $currencyConversion
     * @return \Eurostop\Organisation\SubmitCurrencyConversionRate
     */
    public function setCurrencyConversion($currencyConversion)
    {
      $this->currencyConversion = $currencyConversion;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Organisation\SubmitCurrencyConversionRate
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
