<?php

namespace Eurostop\Organisation;

class ArrayOfCurrencyConversion implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var CurrencyConversion[] $CurrencyConversion
     */
    protected $CurrencyConversion = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return CurrencyConversion[]
     */
    public function getCurrencyConversion()
    {
      return $this->CurrencyConversion;
    }

    /**
     * @param CurrencyConversion[] $CurrencyConversion
     * @return \Eurostop\Organisation\ArrayOfCurrencyConversion
     */
    public function setCurrencyConversion(array $CurrencyConversion = null)
    {
      $this->CurrencyConversion = $CurrencyConversion;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CurrencyConversion[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return CurrencyConversion
     */
    public function offsetGet($offset)
    {
      return $this->CurrencyConversion[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param CurrencyConversion $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CurrencyConversion[] = $value;
      } else {
        $this->CurrencyConversion[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CurrencyConversion[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return CurrencyConversion Return the current element
     */
    public function current()
    {
      return current($this->CurrencyConversion);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CurrencyConversion);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CurrencyConversion);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CurrencyConversion);
    }

    /**
     * Countable implementation
     *
     * @return CurrencyConversion Return count of elements
     */
    public function count()
    {
      return count($this->CurrencyConversion);
    }

}
