<?php

namespace Eurostop\Loyalty;

class GetCustomersByDate
{

    /**
     * @var \DateTime $createdSinceDate
     */
    protected $createdSinceDate = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @param \DateTime $createdSinceDate
     * @param \DateTime $modifiedSinceDate
     */
    public function __construct(\DateTime $createdSinceDate = null, \DateTime $modifiedSinceDate = null)
    {
      $this->createdSinceDate = $createdSinceDate ? $createdSinceDate->format(\DateTime::ATOM) : null;
      $this->modifiedSinceDate = $modifiedSinceDate ? $modifiedSinceDate->format(\DateTime::ATOM) : null;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedSinceDate()
    {
      if ($this->createdSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdSinceDate
     * @return \Eurostop\Loyalty\GetCustomersByDate
     */
    public function setCreatedSinceDate(\DateTime $createdSinceDate)
    {
      $this->createdSinceDate = $createdSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Loyalty\GetCustomersByDate
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

}
