<?php

namespace Eurostop\Loyalty;

class ArrayOfCustomerAttribute implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var CustomerAttribute[] $CustomerAttribute
     */
    protected $CustomerAttribute = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return CustomerAttribute[]
     */
    public function getCustomerAttribute()
    {
      return $this->CustomerAttribute;
    }

    /**
     * @param CustomerAttribute[] $CustomerAttribute
     * @return \Eurostop\Loyalty\ArrayOfCustomerAttribute
     */
    public function setCustomerAttribute(array $CustomerAttribute = null)
    {
      $this->CustomerAttribute = $CustomerAttribute;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CustomerAttribute[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return CustomerAttribute
     */
    public function offsetGet($offset)
    {
      return $this->CustomerAttribute[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param CustomerAttribute $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CustomerAttribute[] = $value;
      } else {
        $this->CustomerAttribute[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CustomerAttribute[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return CustomerAttribute Return the current element
     */
    public function current()
    {
      return current($this->CustomerAttribute);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CustomerAttribute);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CustomerAttribute);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CustomerAttribute);
    }

    /**
     * Countable implementation
     *
     * @return CustomerAttribute Return count of elements
     */
    public function count()
    {
      return count($this->CustomerAttribute);
    }

}
