<?php

namespace Eurostop\Loyalty;

class ArrayOfCustomer implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Customer[] $Customer
     */
    protected $Customer = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Customer[]
     */
    public function getCustomer()
    {
      return $this->Customer;
    }

    /**
     * @param Customer[] $Customer
     * @return \Eurostop\Loyalty\ArrayOfCustomer
     */
    public function setCustomer(array $Customer = null)
    {
      $this->Customer = $Customer;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Customer[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Customer
     */
    public function offsetGet($offset)
    {
      return $this->Customer[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Customer $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Customer[] = $value;
      } else {
        $this->Customer[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Customer[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Customer Return the current element
     */
    public function current()
    {
      return current($this->Customer);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Customer);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Customer);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Customer);
    }

    /**
     * Countable implementation
     *
     * @return Customer Return count of elements
     */
    public function count()
    {
      return count($this->Customer);
    }

}
