<?php

namespace Eurostop\Fulfilment;

class GetCustomerOrdersByCreationDate
{

    /**
     * @var \DateTime $fromDate
     */
    protected $fromDate = null;

    /**
     * @var \DateTime $toDate
     */
    protected $toDate = null;

    /**
     * @var CustomerOrderStatus $orderStatus
     */
    protected $orderStatus = null;

    /**
     * @var int $maxCustomerOrders
     */
    protected $maxCustomerOrders = null;

    /**
     * @param \DateTime $fromDate
     * @param \DateTime $toDate
     * @param CustomerOrderStatus $orderStatus
     * @param int $maxCustomerOrders
     */
    public function __construct(\DateTime $fromDate = null, \DateTime $toDate = null, $orderStatus = null, $maxCustomerOrders = null)
    {
      $this->fromDate = $fromDate ? $fromDate->format(\DateTime::ATOM) : null;
      $this->toDate = $toDate ? $toDate->format(\DateTime::ATOM) : null;
      $this->orderStatus = $orderStatus;
      $this->maxCustomerOrders = $maxCustomerOrders;
    }

    /**
     * @return \DateTime
     */
    public function getFromDate()
    {
      if ($this->fromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->fromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $fromDate
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCreationDate
     */
    public function setFromDate(\DateTime $fromDate)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getToDate()
    {
      if ($this->toDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->toDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $toDate
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCreationDate
     */
    public function setToDate(\DateTime $toDate)
    {
      $this->toDate = $toDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return CustomerOrderStatus
     */
    public function getOrderStatus()
    {
      return $this->orderStatus;
    }

    /**
     * @param CustomerOrderStatus $orderStatus
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCreationDate
     */
    public function setOrderStatus($orderStatus)
    {
      $this->orderStatus = $orderStatus;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxCustomerOrders()
    {
      return $this->maxCustomerOrders;
    }

    /**
     * @param int $maxCustomerOrders
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCreationDate
     */
    public function setMaxCustomerOrders($maxCustomerOrders)
    {
      $this->maxCustomerOrders = $maxCustomerOrders;
      return $this;
    }

}
