<?php

namespace Eurostop\Fulfilment;

class CustomerOrderShipment extends RetrievedDataItemOfCustomerOrderShipmentDtoHay9ORuz
{

    /**
     * @var string $CarrierIdentifier
     */
    protected $CarrierIdentifier = null;

    /**
     * @var string $Comments
     */
    protected $Comments = null;

    /**
     * @var \DateTime $ConfirmedDate
     */
    protected $ConfirmedDate = null;

    /**
     * @var string $DeliveryService
     */
    protected $DeliveryService = null;

    /**
     * @var ArrayOfCustomerOrderShipmentDetail $Details
     */
    protected $Details = null;

    /**
     * @var int $ShipmentNumber
     */
    protected $ShipmentNumber = null;

    /**
     * @var \DateTime $ShippedDate
     */
    protected $ShippedDate = null;

    /**
     * @var string $TrackingInformation
     */
    protected $TrackingInformation = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return string
     */
    public function getCarrierIdentifier()
    {
      return $this->CarrierIdentifier;
    }

    /**
     * @param string $CarrierIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setCarrierIdentifier($CarrierIdentifier)
    {
      $this->CarrierIdentifier = $CarrierIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getComments()
    {
      return $this->Comments;
    }

    /**
     * @param string $Comments
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setComments($Comments)
    {
      $this->Comments = $Comments;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedDate()
    {
      if ($this->ConfirmedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ConfirmedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ConfirmedDate
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setConfirmedDate(\DateTime $ConfirmedDate = null)
    {
      if ($ConfirmedDate == null) {
       $this->ConfirmedDate = null;
      } else {
        $this->ConfirmedDate = $ConfirmedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryService()
    {
      return $this->DeliveryService;
    }

    /**
     * @param string $DeliveryService
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setDeliveryService($DeliveryService)
    {
      $this->DeliveryService = $DeliveryService;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderShipmentDetail
     */
    public function getDetails()
    {
      return $this->Details;
    }

    /**
     * @param ArrayOfCustomerOrderShipmentDetail $Details
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setDetails($Details)
    {
      $this->Details = $Details;
      return $this;
    }

    /**
     * @return int
     */
    public function getShipmentNumber()
    {
      return $this->ShipmentNumber;
    }

    /**
     * @param int $ShipmentNumber
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setShipmentNumber($ShipmentNumber)
    {
      $this->ShipmentNumber = $ShipmentNumber;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getShippedDate()
    {
      if ($this->ShippedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ShippedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ShippedDate
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setShippedDate(\DateTime $ShippedDate = null)
    {
      if ($ShippedDate == null) {
       $this->ShippedDate = null;
      } else {
        $this->ShippedDate = $ShippedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getTrackingInformation()
    {
      return $this->TrackingInformation;
    }

    /**
     * @param string $TrackingInformation
     * @return \Eurostop\Fulfilment\CustomerOrderShipment
     */
    public function setTrackingInformation($TrackingInformation)
    {
      $this->TrackingInformation = $TrackingInformation;
      return $this;
    }

}
