<?php

namespace Eurostop\Fulfilment;

class CustomerOrder extends CodedRetrievedDataItemOfCustomerOrderDtoHay9ORuz
{

    /**
     * @var \DateTime $ArchiveDate
     */
    protected $ArchiveDate = null;

    /**
     * @var string $Comments
     */
    protected $Comments = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var string $CustomerIdentifier
     */
    protected $CustomerIdentifier = null;

    /**
     * @var string $CustomerNotes1
     */
    protected $CustomerNotes1 = null;

    /**
     * @var string $CustomerNotes2
     */
    protected $CustomerNotes2 = null;

    /**
     * @var float $CustomsValue
     */
    protected $CustomsValue = null;

    /**
     * @var CustomerAddress $DeliveryAddress
     */
    protected $DeliveryAddress = null;

    /**
     * @var string $DeliveryAgent
     */
    protected $DeliveryAgent = null;

    /**
     * @var float $DeliveryChargeValue
     */
    protected $DeliveryChargeValue = null;

    /**
     * @var string $DeliveryInformation
     */
    protected $DeliveryInformation = null;

    /**
     * @var string $DeliveryInstructions1
     */
    protected $DeliveryInstructions1 = null;

    /**
     * @var string $DeliveryInstructions2
     */
    protected $DeliveryInstructions2 = null;

    /**
     * @var string $DeliveryMethod
     */
    protected $DeliveryMethod = null;

    /**
     * @var string $DeliveryService
     */
    protected $DeliveryService = null;

    /**
     * @var float $DeliveryVatValue
     */
    protected $DeliveryVatValue = null;

    /**
     * @var string $ExternalOrderNumber
     */
    protected $ExternalOrderNumber = null;

    /**
     * @var ArrayOfCustomerOrderLine $Lines
     */
    protected $Lines = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var CustomerOrderStatus $OrderStatus
     */
    protected $OrderStatus = null;

    /**
     * @var ArrayOfCustomerOrderFulfilmentPlan $Plans
     */
    protected $Plans = null;

    /**
     * @var string $ReceipientContactName
     */
    protected $ReceipientContactName = null;

    /**
     * @var string $ReceipientEmail
     */
    protected $ReceipientEmail = null;

    /**
     * @var string $ReceipientPhoneNumber1
     */
    protected $ReceipientPhoneNumber1 = null;

    /**
     * @var string $ReceipientPhoneNumber2
     */
    protected $ReceipientPhoneNumber2 = null;

    /**
     * @var string $Reference1
     */
    protected $Reference1 = null;

    /**
     * @var string $Reference2
     */
    protected $Reference2 = null;

    /**
     * @var string $SaleBranchIdentifier
     */
    protected $SaleBranchIdentifier = null;

    /**
     * @var ArrayOfCustomerOrderShipment $Shipments
     */
    protected $Shipments = null;

    /**
     * @var string $UserDefinedData1
     */
    protected $UserDefinedData1 = null;

    /**
     * @var string $UserDefinedData2
     */
    protected $UserDefinedData2 = null;

    /**
     * @var string $UserDefinedData3
     */
    protected $UserDefinedData3 = null;

    /**
     * @var string $UserDefinedData4
     */
    protected $UserDefinedData4 = null;

    /**
     * @var string $UserDefinedData5
     */
    protected $UserDefinedData5 = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return \DateTime
     */
    public function getArchiveDate()
    {
      if ($this->ArchiveDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ArchiveDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ArchiveDate
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setArchiveDate(\DateTime $ArchiveDate = null)
    {
      if ($ArchiveDate == null) {
       $this->ArchiveDate = null;
      } else {
        $this->ArchiveDate = $ArchiveDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getComments()
    {
      return $this->Comments;
    }

    /**
     * @param string $Comments
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setComments($Comments)
    {
      $this->Comments = $Comments;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setCreatedDate(\DateTime $CreatedDate = null)
    {
      if ($CreatedDate == null) {
       $this->CreatedDate = null;
      } else {
        $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->CustomerIdentifier;
    }

    /**
     * @param string $CustomerIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setCustomerIdentifier($CustomerIdentifier)
    {
      $this->CustomerIdentifier = $CustomerIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerNotes1()
    {
      return $this->CustomerNotes1;
    }

    /**
     * @param string $CustomerNotes1
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setCustomerNotes1($CustomerNotes1)
    {
      $this->CustomerNotes1 = $CustomerNotes1;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerNotes2()
    {
      return $this->CustomerNotes2;
    }

    /**
     * @param string $CustomerNotes2
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setCustomerNotes2($CustomerNotes2)
    {
      $this->CustomerNotes2 = $CustomerNotes2;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomsValue()
    {
      return $this->CustomsValue;
    }

    /**
     * @param float $CustomsValue
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setCustomsValue($CustomsValue)
    {
      $this->CustomsValue = $CustomsValue;
      return $this;
    }

    /**
     * @return CustomerAddress
     */
    public function getDeliveryAddress()
    {
      return $this->DeliveryAddress;
    }

    /**
     * @param CustomerAddress $DeliveryAddress
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryAddress($DeliveryAddress)
    {
      $this->DeliveryAddress = $DeliveryAddress;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryAgent()
    {
      return $this->DeliveryAgent;
    }

    /**
     * @param string $DeliveryAgent
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryAgent($DeliveryAgent)
    {
      $this->DeliveryAgent = $DeliveryAgent;
      return $this;
    }

    /**
     * @return float
     */
    public function getDeliveryChargeValue()
    {
      return $this->DeliveryChargeValue;
    }

    /**
     * @param float $DeliveryChargeValue
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryChargeValue($DeliveryChargeValue)
    {
      $this->DeliveryChargeValue = $DeliveryChargeValue;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryInformation()
    {
      return $this->DeliveryInformation;
    }

    /**
     * @param string $DeliveryInformation
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryInformation($DeliveryInformation)
    {
      $this->DeliveryInformation = $DeliveryInformation;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryInstructions1()
    {
      return $this->DeliveryInstructions1;
    }

    /**
     * @param string $DeliveryInstructions1
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryInstructions1($DeliveryInstructions1)
    {
      $this->DeliveryInstructions1 = $DeliveryInstructions1;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryInstructions2()
    {
      return $this->DeliveryInstructions2;
    }

    /**
     * @param string $DeliveryInstructions2
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryInstructions2($DeliveryInstructions2)
    {
      $this->DeliveryInstructions2 = $DeliveryInstructions2;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryMethod()
    {
      return $this->DeliveryMethod;
    }

    /**
     * @param string $DeliveryMethod
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryMethod($DeliveryMethod)
    {
      $this->DeliveryMethod = $DeliveryMethod;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryService()
    {
      return $this->DeliveryService;
    }

    /**
     * @param string $DeliveryService
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryService($DeliveryService)
    {
      $this->DeliveryService = $DeliveryService;
      return $this;
    }

    /**
     * @return float
     */
    public function getDeliveryVatValue()
    {
      return $this->DeliveryVatValue;
    }

    /**
     * @param float $DeliveryVatValue
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setDeliveryVatValue($DeliveryVatValue)
    {
      $this->DeliveryVatValue = $DeliveryVatValue;
      return $this;
    }

    /**
     * @return string
     */
    public function getExternalOrderNumber()
    {
      return $this->ExternalOrderNumber;
    }

    /**
     * @param string $ExternalOrderNumber
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setExternalOrderNumber($ExternalOrderNumber)
    {
      $this->ExternalOrderNumber = $ExternalOrderNumber;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderLine
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfCustomerOrderLine $Lines
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setModifiedDate(\DateTime $ModifiedDate = null)
    {
      if ($ModifiedDate == null) {
       $this->ModifiedDate = null;
      } else {
        $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return CustomerOrderStatus
     */
    public function getOrderStatus()
    {
      return $this->OrderStatus;
    }

    /**
     * @param CustomerOrderStatus $OrderStatus
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setOrderStatus($OrderStatus)
    {
      $this->OrderStatus = $OrderStatus;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderFulfilmentPlan
     */
    public function getPlans()
    {
      return $this->Plans;
    }

    /**
     * @param ArrayOfCustomerOrderFulfilmentPlan $Plans
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setPlans($Plans)
    {
      $this->Plans = $Plans;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientContactName()
    {
      return $this->ReceipientContactName;
    }

    /**
     * @param string $ReceipientContactName
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setReceipientContactName($ReceipientContactName)
    {
      $this->ReceipientContactName = $ReceipientContactName;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientEmail()
    {
      return $this->ReceipientEmail;
    }

    /**
     * @param string $ReceipientEmail
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setReceipientEmail($ReceipientEmail)
    {
      $this->ReceipientEmail = $ReceipientEmail;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientPhoneNumber1()
    {
      return $this->ReceipientPhoneNumber1;
    }

    /**
     * @param string $ReceipientPhoneNumber1
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setReceipientPhoneNumber1($ReceipientPhoneNumber1)
    {
      $this->ReceipientPhoneNumber1 = $ReceipientPhoneNumber1;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientPhoneNumber2()
    {
      return $this->ReceipientPhoneNumber2;
    }

    /**
     * @param string $ReceipientPhoneNumber2
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setReceipientPhoneNumber2($ReceipientPhoneNumber2)
    {
      $this->ReceipientPhoneNumber2 = $ReceipientPhoneNumber2;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference1()
    {
      return $this->Reference1;
    }

    /**
     * @param string $Reference1
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setReference1($Reference1)
    {
      $this->Reference1 = $Reference1;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference2()
    {
      return $this->Reference2;
    }

    /**
     * @param string $Reference2
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setReference2($Reference2)
    {
      $this->Reference2 = $Reference2;
      return $this;
    }

    /**
     * @return string
     */
    public function getSaleBranchIdentifier()
    {
      return $this->SaleBranchIdentifier;
    }

    /**
     * @param string $SaleBranchIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setSaleBranchIdentifier($SaleBranchIdentifier)
    {
      $this->SaleBranchIdentifier = $SaleBranchIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderShipment
     */
    public function getShipments()
    {
      return $this->Shipments;
    }

    /**
     * @param ArrayOfCustomerOrderShipment $Shipments
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setShipments($Shipments)
    {
      $this->Shipments = $Shipments;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData1()
    {
      return $this->UserDefinedData1;
    }

    /**
     * @param string $UserDefinedData1
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setUserDefinedData1($UserDefinedData1)
    {
      $this->UserDefinedData1 = $UserDefinedData1;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData2()
    {
      return $this->UserDefinedData2;
    }

    /**
     * @param string $UserDefinedData2
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setUserDefinedData2($UserDefinedData2)
    {
      $this->UserDefinedData2 = $UserDefinedData2;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData3()
    {
      return $this->UserDefinedData3;
    }

    /**
     * @param string $UserDefinedData3
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setUserDefinedData3($UserDefinedData3)
    {
      $this->UserDefinedData3 = $UserDefinedData3;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData4()
    {
      return $this->UserDefinedData4;
    }

    /**
     * @param string $UserDefinedData4
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setUserDefinedData4($UserDefinedData4)
    {
      $this->UserDefinedData4 = $UserDefinedData4;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData5()
    {
      return $this->UserDefinedData5;
    }

    /**
     * @param string $UserDefinedData5
     * @return \Eurostop\Fulfilment\CustomerOrder
     */
    public function setUserDefinedData5($UserDefinedData5)
    {
      $this->UserDefinedData5 = $UserDefinedData5;
      return $this;
    }

}
