<?php

namespace Eurostop\Stocks;

class SubmittedReplenishmentTarget extends SubmittedDataItemOfSubmittedReplenishmentTargetDto6qbTdoQx
{

    /**
     * @var string $BranchGroupIdentifier
     */
    protected $BranchGroupIdentifier = null;

    /**
     * @var BranchGroupIdentifierType $BranchGroupIdentifierType
     */
    protected $BranchGroupIdentifierType = null;

    /**
     * @var string $BranchGroupMemberIdentifier
     */
    protected $BranchGroupMemberIdentifier = null;

    /**
     * @var BranchGroupMemberIdentifierType $BranchGroupMemberIdentifierType
     */
    protected $BranchGroupMemberIdentifierType = null;

    /**
     * @var int $MinimumQuantity
     */
    protected $MinimumQuantity = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @var string $TargetNameIdentifier
     */
    protected $TargetNameIdentifier = null;

    /**
     * @var ReplenishmentTargetNameIdentifierType $TargetNameIdentifierType
     */
    protected $TargetNameIdentifierType = null;

    /**
     * @var int $TargetQuantity
     */
    protected $TargetQuantity = null;

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     */
    public function __construct($SkuIdentifierType)
    {
      parent::__construct();
      $this->SkuIdentifierType = $SkuIdentifierType;
    }

    /**
     * @return string
     */
    public function getBranchGroupIdentifier()
    {
      return $this->BranchGroupIdentifier;
    }

    /**
     * @param string $BranchGroupIdentifier
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setBranchGroupIdentifier($BranchGroupIdentifier)
    {
      $this->BranchGroupIdentifier = $BranchGroupIdentifier;
      return $this;
    }

    /**
     * @return BranchGroupIdentifierType
     */
    public function getBranchGroupIdentifierType()
    {
      return $this->BranchGroupIdentifierType;
    }

    /**
     * @param BranchGroupIdentifierType $BranchGroupIdentifierType
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setBranchGroupIdentifierType($BranchGroupIdentifierType)
    {
      $this->BranchGroupIdentifierType = $BranchGroupIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchGroupMemberIdentifier()
    {
      return $this->BranchGroupMemberIdentifier;
    }

    /**
     * @param string $BranchGroupMemberIdentifier
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setBranchGroupMemberIdentifier($BranchGroupMemberIdentifier)
    {
      $this->BranchGroupMemberIdentifier = $BranchGroupMemberIdentifier;
      return $this;
    }

    /**
     * @return BranchGroupMemberIdentifierType
     */
    public function getBranchGroupMemberIdentifierType()
    {
      return $this->BranchGroupMemberIdentifierType;
    }

    /**
     * @param BranchGroupMemberIdentifierType $BranchGroupMemberIdentifierType
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setBranchGroupMemberIdentifierType($BranchGroupMemberIdentifierType)
    {
      $this->BranchGroupMemberIdentifierType = $BranchGroupMemberIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getMinimumQuantity()
    {
      return $this->MinimumQuantity;
    }

    /**
     * @param int $MinimumQuantity
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setMinimumQuantity($MinimumQuantity)
    {
      $this->MinimumQuantity = $MinimumQuantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getTargetNameIdentifier()
    {
      return $this->TargetNameIdentifier;
    }

    /**
     * @param string $TargetNameIdentifier
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setTargetNameIdentifier($TargetNameIdentifier)
    {
      $this->TargetNameIdentifier = $TargetNameIdentifier;
      return $this;
    }

    /**
     * @return ReplenishmentTargetNameIdentifierType
     */
    public function getTargetNameIdentifierType()
    {
      return $this->TargetNameIdentifierType;
    }

    /**
     * @param ReplenishmentTargetNameIdentifierType $TargetNameIdentifierType
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setTargetNameIdentifierType($TargetNameIdentifierType)
    {
      $this->TargetNameIdentifierType = $TargetNameIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getTargetQuantity()
    {
      return $this->TargetQuantity;
    }

    /**
     * @param int $TargetQuantity
     * @return \Eurostop\Stocks\SubmittedReplenishmentTarget
     */
    public function setTargetQuantity($TargetQuantity)
    {
      $this->TargetQuantity = $TargetQuantity;
      return $this;
    }

}
