<?php

namespace Eurostop\Stocks;

class SubmittedPurchaseOrderLine extends SubmittedDataItemOfSubmittedPurchaseOrderLineDto6qbTdoQx
{

    /**
     * @var \DateTime $AuthorisedDate
     */
    protected $AuthorisedDate = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var string $Comments
     */
    protected $Comments = null;

    /**
     * @var string $CurrencyIdentifier
     */
    protected $CurrencyIdentifier = null;

    /**
     * @var CurrencyIdentifierType $CurrencyIdentifierType
     */
    protected $CurrencyIdentifierType = null;

    /**
     * @var \DateTime $CustomDate1
     */
    protected $CustomDate1 = null;

    /**
     * @var \DateTime $CustomDate2
     */
    protected $CustomDate2 = null;

    /**
     * @var \DateTime $CustomDate3
     */
    protected $CustomDate3 = null;

    /**
     * @var \DateTime $IntendedDeliveryEndDate
     */
    protected $IntendedDeliveryEndDate = null;

    /**
     * @var \DateTime $IntendedDeliveryStartDate
     */
    protected $IntendedDeliveryStartDate = null;

    /**
     * @var int $IntendedQuantity
     */
    protected $IntendedQuantity = null;

    /**
     * @var boolean $IsCancelled
     */
    protected $IsCancelled = null;

    /**
     * @var string $PurchaseOrderIdentifier
     */
    protected $PurchaseOrderIdentifier = null;

    /**
     * @var PurchaseOrderIdentifierType $PurchaseOrderIdentifierType
     */
    protected $PurchaseOrderIdentifierType = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @var string $SupplierIdentifier
     */
    protected $SupplierIdentifier = null;

    /**
     * @var SupplierIdentifierType $SupplierIdentifierType
     */
    protected $SupplierIdentifierType = null;

    /**
     * @var float $UnitCostPrice
     */
    protected $UnitCostPrice = null;

    /**
     * @param int $IntendedQuantity
     * @param SkuIdentifierType $SkuIdentifierType
     * @param float $UnitCostPrice
     */
    public function __construct($IntendedQuantity, $SkuIdentifierType, $UnitCostPrice)
    {
      parent::__construct();
      $this->IntendedQuantity = $IntendedQuantity;
      $this->SkuIdentifierType = $SkuIdentifierType;
      $this->UnitCostPrice = $UnitCostPrice;
    }

    /**
     * @return \DateTime
     */
    public function getAuthorisedDate()
    {
      if ($this->AuthorisedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AuthorisedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AuthorisedDate
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setAuthorisedDate(\DateTime $AuthorisedDate = null)
    {
      if ($AuthorisedDate == null) {
       $this->AuthorisedDate = null;
      } else {
        $this->AuthorisedDate = $AuthorisedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getComments()
    {
      return $this->Comments;
    }

    /**
     * @param string $Comments
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setComments($Comments)
    {
      $this->Comments = $Comments;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrencyIdentifier()
    {
      return $this->CurrencyIdentifier;
    }

    /**
     * @param string $CurrencyIdentifier
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setCurrencyIdentifier($CurrencyIdentifier)
    {
      $this->CurrencyIdentifier = $CurrencyIdentifier;
      return $this;
    }

    /**
     * @return CurrencyIdentifierType
     */
    public function getCurrencyIdentifierType()
    {
      return $this->CurrencyIdentifierType;
    }

    /**
     * @param CurrencyIdentifierType $CurrencyIdentifierType
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setCurrencyIdentifierType($CurrencyIdentifierType)
    {
      $this->CurrencyIdentifierType = $CurrencyIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate1()
    {
      if ($this->CustomDate1 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate1);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate1
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setCustomDate1(\DateTime $CustomDate1 = null)
    {
      if ($CustomDate1 == null) {
       $this->CustomDate1 = null;
      } else {
        $this->CustomDate1 = $CustomDate1->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate2()
    {
      if ($this->CustomDate2 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate2);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate2
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setCustomDate2(\DateTime $CustomDate2 = null)
    {
      if ($CustomDate2 == null) {
       $this->CustomDate2 = null;
      } else {
        $this->CustomDate2 = $CustomDate2->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate3()
    {
      if ($this->CustomDate3 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate3);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate3
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setCustomDate3(\DateTime $CustomDate3 = null)
    {
      if ($CustomDate3 == null) {
       $this->CustomDate3 = null;
      } else {
        $this->CustomDate3 = $CustomDate3->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getIntendedDeliveryEndDate()
    {
      if ($this->IntendedDeliveryEndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->IntendedDeliveryEndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $IntendedDeliveryEndDate
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setIntendedDeliveryEndDate(\DateTime $IntendedDeliveryEndDate = null)
    {
      if ($IntendedDeliveryEndDate == null) {
       $this->IntendedDeliveryEndDate = null;
      } else {
        $this->IntendedDeliveryEndDate = $IntendedDeliveryEndDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getIntendedDeliveryStartDate()
    {
      if ($this->IntendedDeliveryStartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->IntendedDeliveryStartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $IntendedDeliveryStartDate
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setIntendedDeliveryStartDate(\DateTime $IntendedDeliveryStartDate = null)
    {
      if ($IntendedDeliveryStartDate == null) {
       $this->IntendedDeliveryStartDate = null;
      } else {
        $this->IntendedDeliveryStartDate = $IntendedDeliveryStartDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getIntendedQuantity()
    {
      return $this->IntendedQuantity;
    }

    /**
     * @param int $IntendedQuantity
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setIntendedQuantity($IntendedQuantity)
    {
      $this->IntendedQuantity = $IntendedQuantity;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsCancelled()
    {
      return $this->IsCancelled;
    }

    /**
     * @param boolean $IsCancelled
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setIsCancelled($IsCancelled)
    {
      $this->IsCancelled = $IsCancelled;
      return $this;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->PurchaseOrderIdentifier;
    }

    /**
     * @param string $PurchaseOrderIdentifier
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setPurchaseOrderIdentifier($PurchaseOrderIdentifier)
    {
      $this->PurchaseOrderIdentifier = $PurchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return PurchaseOrderIdentifierType
     */
    public function getPurchaseOrderIdentifierType()
    {
      return $this->PurchaseOrderIdentifierType;
    }

    /**
     * @param PurchaseOrderIdentifierType $PurchaseOrderIdentifierType
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setPurchaseOrderIdentifierType($PurchaseOrderIdentifierType)
    {
      $this->PurchaseOrderIdentifierType = $PurchaseOrderIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierIdentifier()
    {
      return $this->SupplierIdentifier;
    }

    /**
     * @param string $SupplierIdentifier
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setSupplierIdentifier($SupplierIdentifier)
    {
      $this->SupplierIdentifier = $SupplierIdentifier;
      return $this;
    }

    /**
     * @return SupplierIdentifierType
     */
    public function getSupplierIdentifierType()
    {
      return $this->SupplierIdentifierType;
    }

    /**
     * @param SupplierIdentifierType $SupplierIdentifierType
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setSupplierIdentifierType($SupplierIdentifierType)
    {
      $this->SupplierIdentifierType = $SupplierIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitCostPrice()
    {
      return $this->UnitCostPrice;
    }

    /**
     * @param float $UnitCostPrice
     * @return \Eurostop\Stocks\SubmittedPurchaseOrderLine
     */
    public function setUnitCostPrice($UnitCostPrice)
    {
      $this->UnitCostPrice = $UnitCostPrice;
      return $this;
    }

}
