<?php

namespace Eurostop\Stocks;

class SubmitTransferBatches
{

    /**
     * @var ArrayOfSubmittedTransferHeader $transfers
     */
    protected $transfers = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedTransferHeader $transfers
     * @param string $submissionReference
     */
    public function __construct($transfers, $submissionReference)
    {
      $this->transfers = $transfers;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedTransferHeader
     */
    public function getTransfers()
    {
      return $this->transfers;
    }

    /**
     * @param ArrayOfSubmittedTransferHeader $transfers
     * @return \Eurostop\Stocks\SubmitTransferBatches
     */
    public function setTransfers($transfers)
    {
      $this->transfers = $transfers;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitTransferBatches
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
