<?php

namespace Eurostop\Stocks;

class SubmitTransferBatch
{

    /**
     * @var SubmittedTransferHeader $transfer
     */
    protected $transfer = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedTransferHeader $transfer
     * @param string $submissionReference
     */
    public function __construct($transfer, $submissionReference)
    {
      $this->transfer = $transfer;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedTransferHeader
     */
    public function getTransfer()
    {
      return $this->transfer;
    }

    /**
     * @param SubmittedTransferHeader $transfer
     * @return \Eurostop\Stocks\SubmitTransferBatch
     */
    public function setTransfer($transfer)
    {
      $this->transfer = $transfer;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitTransferBatch
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
