<?php

namespace Eurostop\Stocks;

class SubmitPurchaseOrders
{

    /**
     * @var ArrayOfSubmittedPurchaseOrderLine $purchaseOrderLines
     */
    protected $purchaseOrderLines = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedPurchaseOrderLine $purchaseOrderLines
     * @param string $submissionReference
     */
    public function __construct($purchaseOrderLines, $submissionReference)
    {
      $this->purchaseOrderLines = $purchaseOrderLines;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedPurchaseOrderLine
     */
    public function getPurchaseOrderLines()
    {
      return $this->purchaseOrderLines;
    }

    /**
     * @param ArrayOfSubmittedPurchaseOrderLine $purchaseOrderLines
     * @return \Eurostop\Stocks\SubmitPurchaseOrders
     */
    public function setPurchaseOrderLines($purchaseOrderLines)
    {
      $this->purchaseOrderLines = $purchaseOrderLines;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitPurchaseOrders
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
