<?php

namespace Eurostop\Stocks;

class SubmitPurchaseOrderActions
{

    /**
     * @var ArrayOfSubmittedPurchaseOrderAction $purchaseOrderActions
     */
    protected $purchaseOrderActions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedPurchaseOrderAction $purchaseOrderActions
     * @param string $submissionReference
     */
    public function __construct($purchaseOrderActions, $submissionReference)
    {
      $this->purchaseOrderActions = $purchaseOrderActions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedPurchaseOrderAction
     */
    public function getPurchaseOrderActions()
    {
      return $this->purchaseOrderActions;
    }

    /**
     * @param ArrayOfSubmittedPurchaseOrderAction $purchaseOrderActions
     * @return \Eurostop\Stocks\SubmitPurchaseOrderActions
     */
    public function setPurchaseOrderActions($purchaseOrderActions)
    {
      $this->purchaseOrderActions = $purchaseOrderActions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitPurchaseOrderActions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
