<?php

namespace Eurostop\Stocks;

class GetPurchaseOrdersByWarehouse
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var boolean $includeUnConfirmed
     */
    protected $includeUnConfirmed = null;

    /**
     * @param string $warehouseIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param boolean $includeUnConfirmed
     */
    public function __construct($warehouseIdentifier, $branchIdentifierType, $includeUnConfirmed)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->includeUnConfirmed = $includeUnConfirmed;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouse
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouse
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeUnConfirmed()
    {
      return $this->includeUnConfirmed;
    }

    /**
     * @param boolean $includeUnConfirmed
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouse
     */
    public function setIncludeUnConfirmed($includeUnConfirmed)
    {
      $this->includeUnConfirmed = $includeUnConfirmed;
      return $this;
    }

}
