<?php

namespace Eurostop\Stocks;

class GetPurchaseOrdersByDate
{

    /**
     * @var \DateTime $createdFromDate
     */
    protected $createdFromDate = null;

    /**
     * @var \DateTime $createdToDate
     */
    protected $createdToDate = null;

    /**
     * @var boolean $includeUnConfirmed
     */
    protected $includeUnConfirmed = null;

    /**
     * @param \DateTime $createdFromDate
     * @param \DateTime $createdToDate
     * @param boolean $includeUnConfirmed
     */
    public function __construct(\DateTime $createdFromDate, \DateTime $createdToDate, $includeUnConfirmed)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      $this->includeUnConfirmed = $includeUnConfirmed;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedFromDate()
    {
      if ($this->createdFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdFromDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByDate
     */
    public function setCreatedFromDate(\DateTime $createdFromDate)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedToDate()
    {
      if ($this->createdToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdToDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByDate
     */
    public function setCreatedToDate(\DateTime $createdToDate)
    {
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeUnConfirmed()
    {
      return $this->includeUnConfirmed;
    }

    /**
     * @param boolean $includeUnConfirmed
     * @return \Eurostop\Stocks\GetPurchaseOrdersByDate
     */
    public function setIncludeUnConfirmed($includeUnConfirmed)
    {
      $this->includeUnConfirmed = $includeUnConfirmed;
      return $this;
    }

}
