<?php

namespace Eurostop\Stocks;

class GetPurchaseOrdersByConfirmedDate
{

    /**
     * @var \DateTime $confirmedFromDate
     */
    protected $confirmedFromDate = null;

    /**
     * @var \DateTime $confirmedToDate
     */
    protected $confirmedToDate = null;

    /**
     * @param \DateTime $confirmedFromDate
     * @param \DateTime $confirmedToDate
     */
    public function __construct(\DateTime $confirmedFromDate, \DateTime $confirmedToDate)
    {
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedFromDate()
    {
      if ($this->confirmedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedFromDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByConfirmedDate
     */
    public function setConfirmedFromDate(\DateTime $confirmedFromDate)
    {
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedToDate()
    {
      if ($this->confirmedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedToDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByConfirmedDate
     */
    public function setConfirmedToDate(\DateTime $confirmedToDate)
    {
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
      return $this;
    }

}
