<?php

namespace Eurostop\Stocks;

class GetInOutTransfersByBranchTransferDate
{

    /**
     * @var string $fromBranchIdentifier
     */
    protected $fromBranchIdentifier = null;

    /**
     * @var string $toBranchIdentifier
     */
    protected $toBranchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $createdFromDate
     */
    protected $createdFromDate = null;

    /**
     * @var \DateTime $createdToDate
     */
    protected $createdToDate = null;

    /**
     * @var boolean $includeTransfersOut
     */
    protected $includeTransfersOut = null;

    /**
     * @var boolean $includeTransfersIn
     */
    protected $includeTransfersIn = null;

    /**
     * @var boolean $includeUnConfirmed
     */
    protected $includeUnConfirmed = null;

    /**
     * @param string $fromBranchIdentifier
     * @param string $toBranchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $createdFromDate
     * @param \DateTime $createdToDate
     * @param boolean $includeTransfersOut
     * @param boolean $includeTransfersIn
     * @param boolean $includeUnConfirmed
     */
    public function __construct($fromBranchIdentifier, $toBranchIdentifier, $branchIdentifierType, \DateTime $createdFromDate, \DateTime $createdToDate, $includeTransfersOut, $includeTransfersIn, $includeUnConfirmed)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      $this->toBranchIdentifier = $toBranchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      $this->includeTransfersOut = $includeTransfersOut;
      $this->includeTransfersIn = $includeTransfersIn;
      $this->includeUnConfirmed = $includeUnConfirmed;
    }

    /**
     * @return string
     */
    public function getFromBranchIdentifier()
    {
      return $this->fromBranchIdentifier;
    }

    /**
     * @param string $fromBranchIdentifier
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setFromBranchIdentifier($fromBranchIdentifier)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToBranchIdentifier()
    {
      return $this->toBranchIdentifier;
    }

    /**
     * @param string $toBranchIdentifier
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setToBranchIdentifier($toBranchIdentifier)
    {
      $this->toBranchIdentifier = $toBranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedFromDate()
    {
      if ($this->createdFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdFromDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setCreatedFromDate(\DateTime $createdFromDate)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedToDate()
    {
      if ($this->createdToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdToDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setCreatedToDate(\DateTime $createdToDate)
    {
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersOut()
    {
      return $this->includeTransfersOut;
    }

    /**
     * @param boolean $includeTransfersOut
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setIncludeTransfersOut($includeTransfersOut)
    {
      $this->includeTransfersOut = $includeTransfersOut;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersIn()
    {
      return $this->includeTransfersIn;
    }

    /**
     * @param boolean $includeTransfersIn
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setIncludeTransfersIn($includeTransfersIn)
    {
      $this->includeTransfersIn = $includeTransfersIn;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeUnConfirmed()
    {
      return $this->includeUnConfirmed;
    }

    /**
     * @param boolean $includeUnConfirmed
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchTransferDate
     */
    public function setIncludeUnConfirmed($includeUnConfirmed)
    {
      $this->includeUnConfirmed = $includeUnConfirmed;
      return $this;
    }

}
