<?php

namespace Eurostop\Stocks;

class GetInOutTransfersByBookedInDate
{

    /**
     * @var \DateTime $bookedInFromDate
     */
    protected $bookedInFromDate = null;

    /**
     * @var \DateTime $bookedInToDate
     */
    protected $bookedInToDate = null;

    /**
     * @var boolean $includeTransfersOut
     */
    protected $includeTransfersOut = null;

    /**
     * @var boolean $includeTransfersIn
     */
    protected $includeTransfersIn = null;

    /**
     * @param \DateTime $bookedInFromDate
     * @param \DateTime $bookedInToDate
     * @param boolean $includeTransfersOut
     * @param boolean $includeTransfersIn
     */
    public function __construct(\DateTime $bookedInFromDate, \DateTime $bookedInToDate, $includeTransfersOut, $includeTransfersIn)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      $this->includeTransfersOut = $includeTransfersOut;
      $this->includeTransfersIn = $includeTransfersIn;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInFromDate()
    {
      if ($this->bookedInFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInFromDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBookedInDate
     */
    public function setBookedInFromDate(\DateTime $bookedInFromDate)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInToDate()
    {
      if ($this->bookedInToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInToDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBookedInDate
     */
    public function setBookedInToDate(\DateTime $bookedInToDate)
    {
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersOut()
    {
      return $this->includeTransfersOut;
    }

    /**
     * @param boolean $includeTransfersOut
     * @return \Eurostop\Stocks\GetInOutTransfersByBookedInDate
     */
    public function setIncludeTransfersOut($includeTransfersOut)
    {
      $this->includeTransfersOut = $includeTransfersOut;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersIn()
    {
      return $this->includeTransfersIn;
    }

    /**
     * @param boolean $includeTransfersIn
     * @return \Eurostop\Stocks\GetInOutTransfersByBookedInDate
     */
    public function setIncludeTransfersIn($includeTransfersIn)
    {
      $this->includeTransfersIn = $includeTransfersIn;
      return $this;
    }

}
