<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockBySku
{

    /**
     * @var string $skuIdentifier
     */
    protected $skuIdentifier = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @param string $skuIdentifier
     * @param SkuIdentifierType $skuIdentifierType
     */
    public function __construct($skuIdentifier, $skuIdentifierType)
    {
      $this->skuIdentifier = $skuIdentifier;
      $this->skuIdentifierType = $skuIdentifierType;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->skuIdentifier;
    }

    /**
     * @param string $skuIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockBySku
     */
    public function setSkuIdentifier($skuIdentifier)
    {
      $this->skuIdentifier = $skuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockBySku
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

}
