<?php

namespace Eurostop\Stocks;

class GetConsolidatedTransfersByBranchConfirmedDate
{

    /**
     * @var string $fromBranchIdentifier
     */
    protected $fromBranchIdentifier = null;

    /**
     * @var string $toBranchIdentifier
     */
    protected $toBranchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $confirmedFromDate
     */
    protected $confirmedFromDate = null;

    /**
     * @var \DateTime $confirmedToDate
     */
    protected $confirmedToDate = null;

    /**
     * @param string $fromBranchIdentifier
     * @param string $toBranchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $confirmedFromDate
     * @param \DateTime $confirmedToDate
     */
    public function __construct($fromBranchIdentifier, $toBranchIdentifier, $branchIdentifierType, \DateTime $confirmedFromDate, \DateTime $confirmedToDate)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      $this->toBranchIdentifier = $toBranchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getFromBranchIdentifier()
    {
      return $this->fromBranchIdentifier;
    }

    /**
     * @param string $fromBranchIdentifier
     * @return \Eurostop\Stocks\GetConsolidatedTransfersByBranchConfirmedDate
     */
    public function setFromBranchIdentifier($fromBranchIdentifier)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToBranchIdentifier()
    {
      return $this->toBranchIdentifier;
    }

    /**
     * @param string $toBranchIdentifier
     * @return \Eurostop\Stocks\GetConsolidatedTransfersByBranchConfirmedDate
     */
    public function setToBranchIdentifier($toBranchIdentifier)
    {
      $this->toBranchIdentifier = $toBranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetConsolidatedTransfersByBranchConfirmedDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedFromDate()
    {
      if ($this->confirmedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedFromDate
     * @return \Eurostop\Stocks\GetConsolidatedTransfersByBranchConfirmedDate
     */
    public function setConfirmedFromDate(\DateTime $confirmedFromDate)
    {
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedToDate()
    {
      if ($this->confirmedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedToDate
     * @return \Eurostop\Stocks\GetConsolidatedTransfersByBranchConfirmedDate
     */
    public function setConfirmedToDate(\DateTime $confirmedToDate)
    {
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
      return $this;
    }

}
