<?php

namespace Eurostop\Stocks;

class GetAllocationsByDelivery
{

    /**
     * @var string $delivaryIdentifier
     */
    protected $delivaryIdentifier = null;

    /**
     * @var DeliveryIdentifierType $delivaryIdentifierType
     */
    protected $delivaryIdentifierType = null;

    /**
     * @param string $delivaryIdentifier
     * @param DeliveryIdentifierType $delivaryIdentifierType
     */
    public function __construct($delivaryIdentifier, $delivaryIdentifierType)
    {
      $this->delivaryIdentifier = $delivaryIdentifier;
      $this->delivaryIdentifierType = $delivaryIdentifierType;
    }

    /**
     * @return string
     */
    public function getDelivaryIdentifier()
    {
      return $this->delivaryIdentifier;
    }

    /**
     * @param string $delivaryIdentifier
     * @return \Eurostop\Stocks\GetAllocationsByDelivery
     */
    public function setDelivaryIdentifier($delivaryIdentifier)
    {
      $this->delivaryIdentifier = $delivaryIdentifier;
      return $this;
    }

    /**
     * @return DeliveryIdentifierType
     */
    public function getDelivaryIdentifierType()
    {
      return $this->delivaryIdentifierType;
    }

    /**
     * @param DeliveryIdentifierType $delivaryIdentifierType
     * @return \Eurostop\Stocks\GetAllocationsByDelivery
     */
    public function setDelivaryIdentifierType($delivaryIdentifierType)
    {
      $this->delivaryIdentifierType = $delivaryIdentifierType;
      return $this;
    }

}
