<?php

namespace Eurostop\Stocks;

class GetAllocationByIdentifierAndBranch
{

    /**
     * @var string $allocationIdentifier
     */
    protected $allocationIdentifier = null;

    /**
     * @var AllocationIdentifierType $allocationIdentifierType
     */
    protected $allocationIdentifierType = null;

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @param string $allocationIdentifier
     * @param AllocationIdentifierType $allocationIdentifierType
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     */
    public function __construct($allocationIdentifier, $allocationIdentifierType, $branchIdentifier, $branchIdentifierType)
    {
      $this->allocationIdentifier = $allocationIdentifier;
      $this->allocationIdentifierType = $allocationIdentifierType;
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
    }

    /**
     * @return string
     */
    public function getAllocationIdentifier()
    {
      return $this->allocationIdentifier;
    }

    /**
     * @param string $allocationIdentifier
     * @return \Eurostop\Stocks\GetAllocationByIdentifierAndBranch
     */
    public function setAllocationIdentifier($allocationIdentifier)
    {
      $this->allocationIdentifier = $allocationIdentifier;
      return $this;
    }

    /**
     * @return AllocationIdentifierType
     */
    public function getAllocationIdentifierType()
    {
      return $this->allocationIdentifierType;
    }

    /**
     * @param AllocationIdentifierType $allocationIdentifierType
     * @return \Eurostop\Stocks\GetAllocationByIdentifierAndBranch
     */
    public function setAllocationIdentifierType($allocationIdentifierType)
    {
      $this->allocationIdentifierType = $allocationIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetAllocationByIdentifierAndBranch
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetAllocationByIdentifierAndBranch
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

}
