<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByModifiedDate
{

    /**
     * @var \DateTime $modifiedFromDate
     */
    protected $modifiedFromDate = null;

    /**
     * @var \DateTime $modifiedToDate
     */
    protected $modifiedToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param \DateTime $modifiedFromDate
     * @param \DateTime $modifiedToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct(\DateTime $modifiedFromDate, \DateTime $modifiedToDate, $status, $isClosed)
    {
      $this->modifiedFromDate = $modifiedFromDate->format(\DateTime::ATOM);
      $this->modifiedToDate = $modifiedToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedFromDate()
    {
      if ($this->modifiedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByModifiedDate
     */
    public function setModifiedFromDate(\DateTime $modifiedFromDate)
    {
      $this->modifiedFromDate = $modifiedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedToDate()
    {
      if ($this->modifiedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByModifiedDate
     */
    public function setModifiedToDate(\DateTime $modifiedToDate)
    {
      $this->modifiedToDate = $modifiedToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByModifiedDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByModifiedDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
