<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByDespatchedDate
{

    /**
     * @var \DateTime $despatchedFromDate
     */
    protected $despatchedFromDate = null;

    /**
     * @var \DateTime $despatchedToDate
     */
    protected $despatchedToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param \DateTime $despatchedFromDate
     * @param \DateTime $despatchedToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct(\DateTime $despatchedFromDate, \DateTime $despatchedToDate, $status, $isClosed)
    {
      $this->despatchedFromDate = $despatchedFromDate->format(\DateTime::ATOM);
      $this->despatchedToDate = $despatchedToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return \DateTime
     */
    public function getDespatchedFromDate()
    {
      if ($this->despatchedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->despatchedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $despatchedFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByDespatchedDate
     */
    public function setDespatchedFromDate(\DateTime $despatchedFromDate)
    {
      $this->despatchedFromDate = $despatchedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDespatchedToDate()
    {
      if ($this->despatchedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->despatchedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $despatchedToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByDespatchedDate
     */
    public function setDespatchedToDate(\DateTime $despatchedToDate)
    {
      $this->despatchedToDate = $despatchedToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByDespatchedDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByDespatchedDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
