<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByCreatedDate
{

    /**
     * @var \DateTime $createdFromDate
     */
    protected $createdFromDate = null;

    /**
     * @var \DateTime $createdToDate
     */
    protected $createdToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param \DateTime $createdFromDate
     * @param \DateTime $createdToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct(\DateTime $createdFromDate, \DateTime $createdToDate, $status, $isClosed)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedFromDate()
    {
      if ($this->createdFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByCreatedDate
     */
    public function setCreatedFromDate(\DateTime $createdFromDate)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedToDate()
    {
      if ($this->createdToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByCreatedDate
     */
    public function setCreatedToDate(\DateTime $createdToDate)
    {
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByCreatedDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByCreatedDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
