<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByBranchModifiedDate
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $modifiedFromDate
     */
    protected $modifiedFromDate = null;

    /**
     * @var \DateTime $modifiedToDate
     */
    protected $modifiedToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param string $warehouseIdentifier
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $modifiedFromDate
     * @param \DateTime $modifiedToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct($warehouseIdentifier, $branchIdentifier, $branchIdentifierType, \DateTime $modifiedFromDate, \DateTime $modifiedToDate, $status, $isClosed)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->modifiedFromDate = $modifiedFromDate->format(\DateTime::ATOM);
      $this->modifiedToDate = $modifiedToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchModifiedDate
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchModifiedDate
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchModifiedDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedFromDate()
    {
      if ($this->modifiedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchModifiedDate
     */
    public function setModifiedFromDate(\DateTime $modifiedFromDate)
    {
      $this->modifiedFromDate = $modifiedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedToDate()
    {
      if ($this->modifiedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchModifiedDate
     */
    public function setModifiedToDate(\DateTime $modifiedToDate)
    {
      $this->modifiedToDate = $modifiedToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchModifiedDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchModifiedDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
