<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByBranchDespatchedDate
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $despatchedFromDate
     */
    protected $despatchedFromDate = null;

    /**
     * @var \DateTime $despatchedToDate
     */
    protected $despatchedToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param string $warehouseIdentifier
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $despatchedFromDate
     * @param \DateTime $despatchedToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct($warehouseIdentifier, $branchIdentifier, $branchIdentifierType, \DateTime $despatchedFromDate, \DateTime $despatchedToDate, $status, $isClosed)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->despatchedFromDate = $despatchedFromDate->format(\DateTime::ATOM);
      $this->despatchedToDate = $despatchedToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchDespatchedDate
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchDespatchedDate
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchDespatchedDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDespatchedFromDate()
    {
      if ($this->despatchedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->despatchedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $despatchedFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchDespatchedDate
     */
    public function setDespatchedFromDate(\DateTime $despatchedFromDate)
    {
      $this->despatchedFromDate = $despatchedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDespatchedToDate()
    {
      if ($this->despatchedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->despatchedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $despatchedToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchDespatchedDate
     */
    public function setDespatchedToDate(\DateTime $despatchedToDate)
    {
      $this->despatchedToDate = $despatchedToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchDespatchedDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchDespatchedDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
