<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedTransferLine implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedTransferLine[] $SubmittedTransferLine
     */
    protected $SubmittedTransferLine = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedTransferLine[]
     */
    public function getSubmittedTransferLine()
    {
      return $this->SubmittedTransferLine;
    }

    /**
     * @param SubmittedTransferLine[] $SubmittedTransferLine
     * @return \Eurostop\Stocks\ArrayOfSubmittedTransferLine
     */
    public function setSubmittedTransferLine(array $SubmittedTransferLine = null)
    {
      $this->SubmittedTransferLine = $SubmittedTransferLine;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedTransferLine[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedTransferLine
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedTransferLine[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedTransferLine $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedTransferLine[] = $value;
      } else {
        $this->SubmittedTransferLine[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedTransferLine[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedTransferLine Return the current element
     */
    public function current()
    {
      return current($this->SubmittedTransferLine);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedTransferLine);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedTransferLine);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedTransferLine);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedTransferLine Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedTransferLine);
    }

}
