<?php

namespace Eurostop\Stocks;

class ArrayOfDeliveryDetail implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var DeliveryDetail[] $DeliveryDetail
     */
    protected $DeliveryDetail = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return DeliveryDetail[]
     */
    public function getDeliveryDetail()
    {
      return $this->DeliveryDetail;
    }

    /**
     * @param DeliveryDetail[] $DeliveryDetail
     * @return \Eurostop\Stocks\ArrayOfDeliveryDetail
     */
    public function setDeliveryDetail(array $DeliveryDetail = null)
    {
      $this->DeliveryDetail = $DeliveryDetail;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->DeliveryDetail[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return DeliveryDetail
     */
    public function offsetGet($offset)
    {
      return $this->DeliveryDetail[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param DeliveryDetail $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->DeliveryDetail[] = $value;
      } else {
        $this->DeliveryDetail[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->DeliveryDetail[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return DeliveryDetail Return the current element
     */
    public function current()
    {
      return current($this->DeliveryDetail);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->DeliveryDetail);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->DeliveryDetail);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->DeliveryDetail);
    }

    /**
     * Countable implementation
     *
     * @return DeliveryDetail Return count of elements
     */
    public function count()
    {
      return count($this->DeliveryDetail);
    }

}
