<?php

namespace Eurostop\Stocks;

class AllocationHeader extends CodedRetrievedDataItemOfAllocationHeaderDto6qbTdoQx
{

    /**
     * @var \DateTime $AuthorisedDate
     */
    protected $AuthorisedDate = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var string $DeliveryIdentifier
     */
    protected $DeliveryIdentifier = null;

    /**
     * @var boolean $IsCancelled
     */
    protected $IsCancelled = null;

    /**
     * @var boolean $IsSentForPicking
     */
    protected $IsSentForPicking = null;

    /**
     * @var ArrayOfAllocationDetail $Lines
     */
    protected $Lines = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var string $PurchaseOrderIdentifier
     */
    protected $PurchaseOrderIdentifier = null;

    /**
     * @var boolean $PurchaseOrdersPlaced
     */
    protected $PurchaseOrdersPlaced = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var string $WarehouseIdentifier
     */
    protected $WarehouseIdentifier = null;

    /**
     * @param \DateTime $CreatedDate
     * @param boolean $IsCancelled
     * @param boolean $IsSentForPicking
     * @param boolean $PurchaseOrdersPlaced
     */
    public function __construct(\DateTime $CreatedDate, $IsCancelled, $IsSentForPicking, $PurchaseOrdersPlaced)
    {
      parent::__construct();
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      $this->IsCancelled = $IsCancelled;
      $this->IsSentForPicking = $IsSentForPicking;
      $this->PurchaseOrdersPlaced = $PurchaseOrdersPlaced;
    }

    /**
     * @return \DateTime
     */
    public function getAuthorisedDate()
    {
      if ($this->AuthorisedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AuthorisedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AuthorisedDate
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setAuthorisedDate(\DateTime $AuthorisedDate = null)
    {
      if ($AuthorisedDate == null) {
       $this->AuthorisedDate = null;
      } else {
        $this->AuthorisedDate = $AuthorisedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setCreatedDate(\DateTime $CreatedDate)
    {
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryIdentifier()
    {
      return $this->DeliveryIdentifier;
    }

    /**
     * @param string $DeliveryIdentifier
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setDeliveryIdentifier($DeliveryIdentifier)
    {
      $this->DeliveryIdentifier = $DeliveryIdentifier;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsCancelled()
    {
      return $this->IsCancelled;
    }

    /**
     * @param boolean $IsCancelled
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setIsCancelled($IsCancelled)
    {
      $this->IsCancelled = $IsCancelled;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsSentForPicking()
    {
      return $this->IsSentForPicking;
    }

    /**
     * @param boolean $IsSentForPicking
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setIsSentForPicking($IsSentForPicking)
    {
      $this->IsSentForPicking = $IsSentForPicking;
      return $this;
    }

    /**
     * @return ArrayOfAllocationDetail
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfAllocationDetail $Lines
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setModifiedDate(\DateTime $ModifiedDate = null)
    {
      if ($ModifiedDate == null) {
       $this->ModifiedDate = null;
      } else {
        $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->PurchaseOrderIdentifier;
    }

    /**
     * @param string $PurchaseOrderIdentifier
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setPurchaseOrderIdentifier($PurchaseOrderIdentifier)
    {
      $this->PurchaseOrderIdentifier = $PurchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getPurchaseOrdersPlaced()
    {
      return $this->PurchaseOrdersPlaced;
    }

    /**
     * @param boolean $PurchaseOrdersPlaced
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setPurchaseOrdersPlaced($PurchaseOrdersPlaced)
    {
      $this->PurchaseOrdersPlaced = $PurchaseOrdersPlaced;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->WarehouseIdentifier;
    }

    /**
     * @param string $WarehouseIdentifier
     * @return \Eurostop\Stocks\AllocationHeader
     */
    public function setWarehouseIdentifier($WarehouseIdentifier)
    {
      $this->WarehouseIdentifier = $WarehouseIdentifier;
      return $this;
    }

}
