<?php

namespace Eurostop\Stocks;

class AllocationDetail extends RetrievedDataItemOfAllocationDetailDto6qbTdoQx
{

    /**
     * @var int $AllocationUnits
     */
    protected $AllocationUnits = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var int $InitialAllocationQuantity
     */
    protected $InitialAllocationQuantity = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var int $PickedQuantity
     */
    protected $PickedQuantity = null;

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var float $CostPrice
     */
    protected $CostPrice = null;

    /**
     * @param int $AllocationUnits
     * @param int $InitialAllocationQuantity
     * @param int $LineNumber
     */
    public function __construct($AllocationUnits, $InitialAllocationQuantity, $LineNumber)
    {
      parent::__construct();
      $this->AllocationUnits = $AllocationUnits;
      $this->InitialAllocationQuantity = $InitialAllocationQuantity;
      $this->LineNumber = $LineNumber;
    }

    /**
     * @return int
     */
    public function getAllocationUnits()
    {
      return $this->AllocationUnits;
    }

    /**
     * @param int $AllocationUnits
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setAllocationUnits($AllocationUnits)
    {
      $this->AllocationUnits = $AllocationUnits;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getInitialAllocationQuantity()
    {
      return $this->InitialAllocationQuantity;
    }

    /**
     * @param int $InitialAllocationQuantity
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setInitialAllocationQuantity($InitialAllocationQuantity)
    {
      $this->InitialAllocationQuantity = $InitialAllocationQuantity;
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getPickedQuantity()
    {
      return $this->PickedQuantity;
    }

    /**
     * @param int $PickedQuantity
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setPickedQuantity($PickedQuantity)
    {
      $this->PickedQuantity = $PickedQuantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getCostPrice()
    {
      return $this->CostPrice;
    }

    /**
     * @param float $CostPrice
     * @return \Eurostop\Stocks\AllocationDetail
     */
    public function setCostPrice($CostPrice)
    {
      $this->CostPrice = $CostPrice;
      return $this;
    }

}
