<?php

namespace Eurostop\Stocks;

class AdviceNoteDetail extends RetrievedDataItemOfAdviceNoteDetailDto6qbTdoQx
{

    /**
     * @var int $AllocatedUnits
     */
    protected $AllocatedUnits = null;

    /**
     * @var string $AllocationIdentifier
     */
    protected $AllocationIdentifier = null;

    /**
     * @var int $BoxNumber
     */
    protected $BoxNumber = null;

    /**
     * @var int $DespatchedUnits
     */
    protected $DespatchedUnits = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var float $CostPrice
     */
    protected $CostPrice = null;

    /**
     * @param int $AllocatedUnits
     * @param int $LineNumber
     */
    public function __construct($AllocatedUnits, $LineNumber)
    {
      parent::__construct();
      $this->AllocatedUnits = $AllocatedUnits;
      $this->LineNumber = $LineNumber;
    }

    /**
     * @return int
     */
    public function getAllocatedUnits()
    {
      return $this->AllocatedUnits;
    }

    /**
     * @param int $AllocatedUnits
     * @return \Eurostop\Stocks\AdviceNoteDetail
     */
    public function setAllocatedUnits($AllocatedUnits)
    {
      $this->AllocatedUnits = $AllocatedUnits;
      return $this;
    }

    /**
     * @return string
     */
    public function getAllocationIdentifier()
    {
      return $this->AllocationIdentifier;
    }

    /**
     * @param string $AllocationIdentifier
     * @return \Eurostop\Stocks\AdviceNoteDetail
     */
    public function setAllocationIdentifier($AllocationIdentifier)
    {
      $this->AllocationIdentifier = $AllocationIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getBoxNumber()
    {
      return $this->BoxNumber;
    }

    /**
     * @param int $BoxNumber
     * @return \Eurostop\Stocks\AdviceNoteDetail
     */
    public function setBoxNumber($BoxNumber)
    {
      $this->BoxNumber = $BoxNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getDespatchedUnits()
    {
      return $this->DespatchedUnits;
    }

    /**
     * @param int $DespatchedUnits
     * @return \Eurostop\Stocks\AdviceNoteDetail
     */
    public function setDespatchedUnits($DespatchedUnits)
    {
      $this->DespatchedUnits = $DespatchedUnits;
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Stocks\AdviceNoteDetail
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\AdviceNoteDetail
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getCostPrice()
    {
      return $this->CostPrice;
    }

    /**
     * @param float $CostPrice
     * @return \Eurostop\Stocks\AdviceNoteDetail
     */
    public function setCostPrice($CostPrice)
    {
      $this->CostPrice = $CostPrice;
      return $this;
    }

}
