<?php

namespace Eurostop\Status;

class GetDataProcessingStatusByReferenceAndItem
{

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @var ProcessingStatus $itemStatusCode
     */
    protected $itemStatusCode = null;

    /**
     * @var string $dataItemIdentifier
     */
    protected $dataItemIdentifier = null;

    /**
     * @param string $submissionReference
     * @param ProcessingStatus $itemStatusCode
     * @param string $dataItemIdentifier
     */
    public function __construct($submissionReference, $itemStatusCode, $dataItemIdentifier)
    {
      $this->submissionReference = $submissionReference;
      $this->itemStatusCode = $itemStatusCode;
      $this->dataItemIdentifier = $dataItemIdentifier;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Status\GetDataProcessingStatusByReferenceAndItem
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

    /**
     * @return ProcessingStatus
     */
    public function getItemStatusCode()
    {
      return $this->itemStatusCode;
    }

    /**
     * @param ProcessingStatus $itemStatusCode
     * @return \Eurostop\Status\GetDataProcessingStatusByReferenceAndItem
     */
    public function setItemStatusCode($itemStatusCode)
    {
      $this->itemStatusCode = $itemStatusCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getDataItemIdentifier()
    {
      return $this->dataItemIdentifier;
    }

    /**
     * @param string $dataItemIdentifier
     * @return \Eurostop\Status\GetDataProcessingStatusByReferenceAndItem
     */
    public function setDataItemIdentifier($dataItemIdentifier)
    {
      $this->dataItemIdentifier = $dataItemIdentifier;
      return $this;
    }

}
